/*---------------------------------------------------------------------------*\

	FILE....: ringbug.cpp
	TYPE....: C Program
	AUTHOR..: David Rowe
	DATE....: 13/11/01

	Test program to for reproducing false ring bug.

\*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <pthread.h>
#include <string.h>
#include "../src/vpbapi.h"

#define	BUF_SIZE        320	// size of processing frame (samples) (20ms)
#define NBUFS           200
#define NBEEP           320

// local functions
void *event_thread(void *pv);
void *hook_thread(void *pv);
int kbhit();

int finish;
int rings;
int hook_cycles;
int line1,line2,line3,line4;

int main(int argc, char *argv[])
{
	pthread_t       ev_thread;
	//pthread_t       hk_thread;
	int             i, cycles=0;
	short           buf_rec[BUF_SIZE], buf_play[BUF_SIZE];
	float           pi = 4.0*atan(1.0);

	// initialise 

	line1 = vpb_open(1,1);
	line2 = vpb_open(1,2);
	line3 = vpb_open(1,3);
	line4 = vpb_open(1,4);
	vpb_sethook_sync(line1,VPB_OFFHOOK);

	for(i=0; i<NBEEP; i++) {
		buf_play[i] = (short)(4000.0*cos((2.0*pi*800.0/8000.0)*i));
	}
	for(i=NBEEP; i<BUF_SIZE; i++) {
		buf_play[i] = 0;
	}
	// start main processing loop ---------------------------
		
	finish = 0;
	pthread_create(&ev_thread, NULL, event_thread, NULL);
	//pthread_create(&hk_thread, NULL, hook_thread, NULL);
	       
	while(!kbhit()) {
	
		vpb_record_buf_start(line1, VPB_LINEAR);
		vpb_play_buf_start(line1, VPB_LINEAR);
		for(i=0; i<NBUFS; i++) {
			vpb_record_buf_sync(line1, (char*)buf_rec,
					    sizeof(short)*BUF_SIZE);
			vpb_play_buf_sync(line1, (char*)buf_play,
					  sizeof(short)*BUF_SIZE);
		}
		vpb_record_buf_finish(line1);
		vpb_play_buf_finish(line1);
		printf("cycles: %d  hook cycles: %d rings %d\n",cycles++, 
		       hook_cycles, rings);
	}
		
	finish = 1;
	
	vpb_sethook_sync(line1,VPB_ONHOOK);
	vpb_close(line1);
	vpb_close(line2);
	vpb_close(line3);
	vpb_close(line4);

	return 0;
}	

void *event_thread(void *pv) {
	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	do {
		// check for events from VPB

		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);

			if (e.type == VPB_RING) {
				rings++;
			}
		}

	} while(!finish);

	return NULL;
}

void *hook_thread(void *pv) {

	do {
		vpb_sethook_sync(line1,VPB_OFFHOOK);
		vpb_sleep(1000);
		vpb_sethook_sync(line1,VPB_ONHOOK);
		vpb_sleep(1000);
		hook_cycles++;
	} while(!finish);

	return NULL;
}
